CREATE TABLE `location` (
  `id` int(11) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `status` int(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `location`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `location`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;  

ALTER TABLE `property` ADD `location_id` INT(11) NULL DEFAULT NULL AFTER `type_id`;

INSERT INTO `payment_gateway` (`id`, `gateway_name`, `gateway_short_info`, `gateway_info`, `status`) VALUES (12, 'Bank Transfer', 'Manual Bank Transfer', '{"banktransfer_info":"<p><strong>Account<\/strong>: 2223330032299999<br \/><strong>IFSC<\/strong>: SBIN000123456<br \/><strong>Bank Name<\/strong>: SBI<br \/><strong>Beneficiary Name<\/strong>: John Deo<\/p>\r\n<p><br \/>Transfer the exact amount for the payment to be successful. Please make payment only in the account number mentioned above.<\/p>\r\n<p>If you have any questions, you can contact customer support at any time.<\/p>"}', '0');

INSERT INTO `payment_gateway` (`id`, `gateway_name`, `gateway_short_info`, `gateway_info`, `status`) VALUES ('13', 'Braintree', 'For International Payment', '{\"mode\":\"sandbox\",\"braintree_merchant_id\":null,\"braintree_public_key\":null,\"braintree_private_key\":null,\"braintree_merchant_account_id\":null}', '0');

INSERT INTO `payment_gateway` (`id`, `gateway_name`, `gateway_short_info`, `gateway_info`, `status`) VALUES (14, 'SSLCOMMERZ', 'Payment for Bangladesh', NULL, '0');

INSERT INTO `payment_gateway` (`id`, `gateway_name`, `gateway_short_info`, `gateway_info`, `status`) VALUES (15, 'CinetPay', 'CinetPay for West Africa and Central Africa', NULL, '0');


ALTER TABLE `analytics` CHANGE `id` `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `app_ads` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `favourite` CHANGE `id` `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `location` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `pages` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `password_resets` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `payment_gateway` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `post_views` CHANGE `id` `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `property` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `property_gallery` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `reports` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `settings` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `subscription_plan` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `transaction` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `type` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `users` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;
ALTER TABLE `web_banner_ads` CHANGE `id` `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;

CREATE INDEX idx_property_user_id_type_id_location_id_status ON property(user_id, type_id, location_id, status);

CREATE INDEX idx_gallery_post_id ON property_gallery(post_id);

CREATE INDEX idx_transaction_user_id ON transaction(user_id);